﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;
using VeteransAffairs.Registries.BusinessAHOBPR.Extensions;
namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class MilitaryServiceEpisodeImporter : MilitaryInfoServiceClient
    {

        /// <summary>
        /// 
        /// </summary>
        /// <param name="edipi"></param>
        /// <returns></returns>
        public List<MilitaryServiceEpisode> GetMilitaryServiceEpisodes(string edipi)
        {
            var inputEdipi = InputEdipiOrIcnCreator.Create(edipi);
            eMISserviceEpisodeResponseType response = GetMilitaryServiceEpisodesResponse(inputEdipi, InputHeaderInfo);
            return (response.militaryServiceEpisode != null) ? response.militaryServiceEpisode.ToList() : new List<MilitaryServiceEpisode>();
        }
        public eMISserviceEpisodeResponseType GetMilitaryServiceEpisodesResponse(inputEdiPiOrIcn inputEdipiIcn, InputHeaderInfo inputHeaderInfo)
        {
            eMISserviceEpisodeResponseType response = null;
            try
            {
                response = _client.getMilitaryServiceEpisodes(ref inputHeaderInfo, inputEdipiIcn);
            }
            catch (Exception ex)
            {
                Trace.WriteLine("Exception: ServiceEpisodeImporter.GetServiceResponse: " + ex.Message + "\n" + ex.StackTrace);
                AHOBPRLogger.LogErrorMessage("Exception", this.GetType().Name + "." + System.Reflection.MethodBase.GetCurrentMethod().Name, ex.StackTrace);
            }
            return response;
        }
    }
}
